const fileSelectorMode = "direct";

class SnaatchConstants {
  baseUrl = useBetaVersion.useBetaVersion
    ? "https://app.beta.snaatch.com"
    : "https://app.snaatch.com";
  fileSelectorUrl = `${
    this.baseUrl
  }/?appMode=file-selector&integration=wordpress&fileSelectorMode=${fileSelectorMode}&fileSelectorAction=select&fileSelectorAction=crop${
    importAsWebP.importAsWebP === "1" ? "&fileSelectorFormat=webp" : ""
  }&imageEditorBeta=true`;
  iFrameId = "com_snaatch_integrations_wordpress_iframe";
  tabId = "snaatch";
  tabTitle = "snaatch";
  mediaFrameRouterEntry = { ["snaatch"]: { text: "snaatch", priority: 60 } };
  menuItemId = `menu-item-snaatch`;
  dataSnaatchLoadedAttributeName = "data-snaatch-loaded";
}
const snaatchConstants = new SnaatchConstants();

const loadingSvg =
  "data:image/svg+xml;base64,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";

jQuery(document).ready(function ($) {
  if (wp.media) {
    // ToDo:
    // add class in Library view
    wp.media.view.Attachment.Library = wp.media.view.Attachment.Library.extend({
      className() {
        let parentClassName =
          wp.media.view.Attachment.Library.__super__.className;

        if (!parentClassName || typeof parentClassName === "function") {
          parentClassName = "attachment";
        }

        let className = parentClassName;
        const isSnaatchAttachment =
          this.model.get("snaatch_version_id") !== undefined;
        if (isSnaatchAttachment) {
          className += " isSnaatchAttachment";
        } else {
          className += " elseCase";
        }

        return className;
      },
    });

    // Add the tab to "post" frame
    const oldMediaFramePost = wp.media.view.MediaFrame.Post;
    wp.media.view.MediaFrame.Post = oldMediaFramePost.extend({
      browseRouter(routerView) {
        oldMediaFrameSelect.prototype.browseRouter.apply(this, arguments);
        routerView.set(snaatchConstants.mediaFrameRouterEntry);
      },
    });

    // Add the tab to "select" frame
    const oldMediaFrameSelect = wp.media.view.MediaFrame.Select;
    wp.media.view.MediaFrame.Select = oldMediaFrameSelect.extend({
      browseRouter(routerView) {
        oldMediaFrameSelect.prototype.browseRouter.apply(this, arguments);
        routerView.set(snaatchConstants.mediaFrameRouterEntry);
      },
    });

    // Get element by selector using last element (3rd party plugins handle content differently)
    const getLastElementByQuerySelector = (selector) => {
      const elements = document.querySelectorAll(selector);
      if (elements.length) return elements[elements.length - 1];
    };

    // Get the media router wrapper
    const getMediaRouterWrapper = () =>
      getLastElementByQuerySelector('[class="media-router"]');

    const setIFrame = () => {
      const contentElement =
        getLastElementByQuerySelector(
          `[aria-labelledby="${snaatchConstants.menuItemId}"]`
        ) || getLastElementByQuerySelector(`[class="media-frame-content"]`);

      if (contentElement) {
        // remove all child nodes from contentElement
        contentElement.innerHTML = "";

        const iFrameElement = document.createElement("iframe");
        iFrameElement.id = snaatchConstants.iFrameId;
        iFrameElement.src = snaatchConstants.fileSelectorUrl;
        iFrameElement.style.border = "0";
        iFrameElement.style.width = "100%";
        iFrameElement.style.height = "100%";
        contentElement.appendChild(iFrameElement);

        const loadingElement = document.createElement("div");
        loadingElement.style.position = "absolute";
        loadingElement.style.top = 0;
        loadingElement.style.left = 0;
        loadingElement.style.right = 0;
        loadingElement.style.bottom = 0;
        loadingElement.style.backgroundColor = "#1A202C";
        loadingElement.style.display = "flex";
        loadingElement.style.justifyContent = "center";
        loadingElement.style.alignItems = "center";
        const loader = document.createElement("img");
        // Thanks to https://github.com/SamHerbert/SVG-Loaders
        loader.src = loadingSvg;
        loadingElement.appendChild(loader);

        contentElement.appendChild(loadingElement);
        iFrameElement.onload = () => {
          contentElement.setAttribute(
            snaatchConstants.dataSnaatchLoadedAttributeName,
            true
          );
          loadingElement.remove();
        };

        function handleMessage(message) {
          const frame = wp.media.frame;
          const library = frame.state()?.get("library");
          const selection = frame?.state()?.get("selection");

          // AJAX call to execute the PHP function
          $.ajax({
            url: ajaxurl,
            type: "POST",
            data: {
              action: "import_image", // The name of your PHP function
              file: {
                id: message.metadata.id,
                filename: message.metadata.name,
                extension:
                  importAsWebP.importAsWebP === "1"
                    ? "webp"
                    : message.metadata.extension,
                url:
                  fileSelectorMode === "direct"
                    ? message.links.raw
                    : message.links.original,
                width: message.metadata.width,
                height: message.metadata.height,
                title: message.metadata.title,
                description: message.metadata.description,
                alt: message.metadata.alt,
              },
            },
            error: function (jqXHR, error, errorThrown) {
              if (jqXHR.status && jqXHR.status == 400) {
                alert(jqXHR.status);
              } else {
                alert(
                  "Unbekannter Fehler. Bitte kontaktieren Sie den Support."
                );
              }
            },
            success: function (response) {
              if (!response.success) {
                console.error("response", response);

                try {
                  const data = JSON.parse(response);
                  alert(data.data);
                  return;
                } catch (e) {
                  alert(
                    "Unbekannter Fehler. Bitte kontaktieren Sie den Support."
                  );
                }
                alert(
                  "Unbekannter Fehler. Bitte kontaktieren Sie den Support."
                );
                return;
              }

              const attachmentData = response.data.data;
              let attachment = library.get(attachmentData.id);
              if (!attachment) {
                attachment = library.add(attachmentData, {
                  merge: true,
                  at: 0,
                });
              }

              // Select the attachment
              selection.add(attachment, {
                merge: true,
              });

              // Navigate to menu-item-browse view
              document.getElementById("menu-item-browse")?.click();
            },
          });
        }

        window.onmessage = (event) => {
          // only accept messages from snaatch
          if (!event.origin.startsWith(snaatchConstants.baseUrl)) {
            return;
          }

          const message = event.data;
          handleMessage(message);
        };
      }
    };

    // Handle tab content
    wp.media.view.Modal.prototype.on("open", function (...args) {
      const searchMediaRouterForMenuItem = () => {
        // Used as a fallback for old wordpress versions
        const mediaRouterWrapper = getMediaRouterWrapper();
        if (mediaRouterWrapper) {
          let index = 0;
          for (let item of mediaRouterWrapper.children) {
            if (item.innerHTML === snaatchConstants.tabTitle) return item;
            index++;
          }
        }
      };
      const addMenuEventListeners = () => {
        const menuItemElement =
          getLastElementByQuerySelector(
            `[id="${snaatchConstants.menuItemId}"]`
          ) || searchMediaRouterForMenuItem();
        if (menuItemElement)
          menuItemElement.addEventListener("click", () => setIFrame());
        setTimeout(() => {
          if (menuItemElement && menuItemElement.className.includes("active")) {
            setTimeout(() => setIFrame(), 100);
          }
        }, 100);
      };
      addMenuEventListeners();
      const mediaModal = getLastElementByQuerySelector("div.media-modal");
      if (mediaModal)
        mediaModal.addEventListener("click", () => addMenuEventListeners());
    });
  }
});
